/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.spell.casters.ReactiveCaster;
import com.rcx.materialis.util.MaterialisPacketHandler;
import com.rcx.materialis.util.PacketReactiveSwing;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.ModList;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.ability.tool.OffhandAttackModifier;

public class ReactiveModifier
extends Modifier {
    public static boolean enabled = ModList.get().isLoaded("ars_nouveau");

    public ReactiveModifier() {
        if (enabled) {
            MinecraftForge.EVENT_BUS.addListener(this::leftClick);
            MinecraftForge.EVENT_BUS.addListener(this::leftClickBlock);
        }
    }

    public void beforeRemoved(IToolStackView tool, RestrictedCompoundTag tag) {
        tag.remove("ars_nouveau_reactiveCaster");
    }

    private void leftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ToolStack tool;
        if (enabled && !event.getItemStack().m_41619_() && (tool = ReactiveModifier.getHeldTool((LivingEntity)event.getEntityLiving(), (InteractionHand)InteractionHand.MAIN_HAND)) != null && tool.getModifierLevel((Modifier)this) > 0) {
            MaterialisPacketHandler.INSTANCE.sendToServer((Object)new PacketReactiveSwing());
        }
    }

    public void recieveLeftClick(Player player) {
        ToolStack tool;
        if (enabled && (tool = ReactiveModifier.getHeldTool((LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND)) != null && !tool.isBroken() && tool.getModifierLevel((Modifier)this) > 0) {
            this.castSpell((IToolStackView)tool, player, player.m_21205_(), InteractionHand.MAIN_HAND);
        }
    }

    public InteractionResult onToolUse(IToolStackView tool, int level, Level world, Player player, InteractionHand hand, EquipmentSlot slotType) {
        if (enabled && !tool.isBroken() && hand == InteractionHand.OFF_HAND && OffhandCooldownTracker.isAttackReady((Player)player) && tool.getVolatileData().getBoolean(OffhandAttackModifier.DUEL_WIELDING)) {
            ItemStack toolStack = player.m_6844_(slotType);
            if (tool instanceof ToolStack) {
                toolStack = ((ToolStack)tool).createStack();
            }
            this.castSpell(tool, player, toolStack, InteractionHand.OFF_HAND);
        }
        return InteractionResult.PASS;
    }

    private void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (enabled) {
            Player player = event.getPlayer();
            if (player.f_19853_.f_46443_) {
                return;
            }
            ToolStack tool = ReactiveModifier.getHeldTool((LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND);
            if (tool != null && !tool.isBroken() && tool.getModifierLevel((Modifier)this) > 0) {
                this.castSpell((IToolStackView)tool, player, event.getItemStack(), InteractionHand.MAIN_HAND);
            }
        }
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (enabled && !tool.isBroken() && context.getPlayerAttacker() != null) {
            ItemStack toolStack = context.getPlayerAttacker().m_21120_(context.getHand());
            if (tool instanceof ToolStack) {
                toolStack = ((ToolStack)tool).createStack();
            }
            this.castSpell(tool, context.getPlayerAttacker(), toolStack, context.getHand());
        }
        return 0;
    }

    public void onAttacked(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (enabled && !tool.isBroken() && context.getEntity() != null && context.getEntity() instanceof Player) {
            ItemStack toolStack = context.getEntity().m_6844_(slotType);
            if (tool instanceof ToolStack) {
                toolStack = ((ToolStack)tool).createStack();
            }
            this.castSpell(tool, (Player)context.getEntity(), toolStack, InteractionHand.MAIN_HAND);
        }
    }

    public void castSpell(IToolStackView tool, Player player, ItemStack stack, InteractionHand hand) {
        if ((double)tool.getModifierLevel((Modifier)this) * 0.25 >= Math.random() && new ReactiveCaster(stack).getSpell().isValid()) {
            ReactiveCaster reactiveCaster = new ReactiveCaster(stack);
            reactiveCaster.castSpell(player.m_20193_(), player, hand, null);
        }
    }

    public void addInformation(IToolStackView tool, int level, Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        Spell spell;
        if (enabled && tool instanceof ToolStack && (spell = new ReactiveCaster(((ToolStack)tool).createStack()).getSpell()).isValid()) {
            tooltip.add((Component)new TextComponent(spell.getDisplayString()));
        }
    }
}

